<?php
include 'includes/db.php';

// Traitement du formulaire
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Récupération des données
    $clients_nom_entreprise = htmlspecialchars($_POST['clients_nom_entreprise']);
    $clients_IF = htmlspecialchars($_POST['clients_IF']);
    $clients_RC = htmlspecialchars($_POST['clients_RC']);
    $clients_CNSS = htmlspecialchars($_POST['clients_CNSS']);
    
    // Gestion du logo
    $clients_logo = '';
    if (isset($_FILES['clients_logo']) && $_FILES['clients_logo']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = 'uploads/logos/';
        if (!file_exists($uploadDir)) mkdir($uploadDir, 0777, true); // Créer le dossier si inexistant
        
        $fileName = uniqid() . '_' . basename($_FILES['clients_logo']['name']);
        $clients_logo = $uploadDir . $fileName;
        move_uploaded_file($_FILES['clients_logo']['tmp_name'], $clients_logo);
    }

    // Insertion en base de données
    try {
        $stmt = $pdo->prepare("
            INSERT INTO clients (
                clients_nom_entreprise, clients_logo, 
                clients_IF, clients_RC, clients_CNSS
            ) VALUES (?, ?, ?, ?, ?)
        ");
        $stmt->execute([
            $clients_nom_entreprise,
            $clients_logo,
            $clients_IF,
            $clients_RC,
            $clients_CNSS
        ]);
        
        header('Location: liste_clients.php');
        exit;
    } catch (PDOException $e) {
        die("Erreur : " . $e->getMessage());
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Ajouter un client</title>
    <link rel="stylesheet" type="text/css" href="styles.css">
</head>
<body>
    <div class="container">
        <h1>Ajouter un client</h1>
        <form method="POST" enctype="multipart/form-data">
            <div class="form-group">
                <label>Nom de l'entreprise :</label>
                <input type="text" name="clients_nom_entreprise" required>
            </div>
            
            <div class="form-group">
                <label>Identifiant Fiscal (IF) :</label>
                <input type="text" name="clients_IF">
            </div>
            
            <div class="form-group">
                <label>Registre de Commerce (RC) :</label>
                <input type="text" name="clients_RC">
            </div>
            
            <div class="form-group">
                <label>CNSS :</label>
                <input type="text" name="clients_CNSS">
            </div>
            
            <div class="form-group">
                <label>Logo :</label>
                <input type="file" name="clients_logo" accept="image/*">
            </div>
            
            <button type="submit" class="btn">Enregistrer</button>
        </form>
    </div>
</body>
</html>