<?php
include 'includes/db.php';

// Récupérer l'ID du client depuis l'URL
$clients_id = isset($_GET['clients_id']) ? intval($_GET['clients_id']) : 0;

// Récupérer les données du client
$stmt = $pdo->prepare("SELECT * FROM clients WHERE clients_id = ?");
$stmt->execute([$clients_id]);
$client = $stmt->fetch(PDO::FETCH_ASSOC);

// Vérifier si le client existe
if (!$client) {
    die("Client non trouvé.");
}

// Template par défaut avec placeholders
$defaultTemplate = '
<div class="entete">
    <img src="{clients_logo}" alt="Logo" style="max-width: 200px;">
    <h1>{clients_nom_entreprise}</h1>
    <p><strong>IF:</strong> {clients_IF}</p>
    <p><strong>RC:</strong> {clients_RC}</p>
    <p><strong>CNSS:</strong> {clients_CNSS}</p>
</div>
';

// Traitement du formulaire
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $entetes_contenu = $_POST['entetes_contenu'];
    
    // Insérer l'en-tête dans la base de données
    try {
        $stmt = $pdo->prepare("
            INSERT INTO entetes (entetes_client_id, entetes_contenu) 
            VALUES (?, ?)
        ");
        $stmt->execute([$clients_id, $entetes_contenu]);
        header('Location: liste_clients.php');
        exit;
    } catch (PDOException $e) {
        die("Erreur : " . $e->getMessage());
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Créer un en-tête</title>
    <link rel="stylesheet" type="text/css" href="styles.css">
</head>
<body>
    <div class="container">
        <h1>Créer un en-tête pour <?= htmlspecialchars($client['clients_nom_entreprise']) ?></h1>
        
        <!-- Aperçu des données du client -->
        <div class="client-info">
            <h3>Informations du client :</h3>
            <p>Logo : <img src="<?= htmlspecialchars($client['clients_logo']) ?>" alt="Logo" style="max-width: 100px;"></p>
            <p>IF : <?= htmlspecialchars($client['clients_IF']) ?></p>
            <p>RC : <?= htmlspecialchars($client['clients_RC']) ?></p>
            <p>CNSS : <?= htmlspecialchars($client['clients_CNSS']) ?></p>
        </div>

        <!-- Formulaire de création d'en-tête -->
        <form method="POST">
            <div class="form-group">
                <label>Contenu de l'en-tête (utilisez les placeholders) :</label>
                <textarea 
                    name="entetes_contenu" 
                    rows="10" 
                    placeholder="Exemple : <img src='{clients_logo}'> ..."
                ><?= htmlspecialchars($defaultTemplate) ?></textarea>
            </div>
            
            <button type="submit" class="btn">Enregistrer l'en-tête</button>
            <a href="liste_clients.php" class="btn btn-cancel">Annuler</a>
        </form>
    </div>
</body>
</html>