<?php
include 'includes/db.php';

// Récupérer la liste des clients
$stmt = $pdo->query("SELECT * FROM clients");
$clients = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Liste des clients</title>
    <link rel="stylesheet" type="text/css" href="styles.css">
</head>
<body>
    <div class="container">
        <h1>Liste des clients</h1>
        <table class="client-table">
            <thead>
                <tr>
                    <th>Nom de l'entreprise</th>
                    <th>IF</th>
                    <th>RC</th>
                    <th>CNSS</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($clients as $client): ?>
                <tr>
                    <td><?= htmlspecialchars($client['clients_nom_entreprise']) ?></td>
                    <td><?= htmlspecialchars($client['clients_IF']) ?></td>
                    <td><?= htmlspecialchars($client['clients_RC']) ?></td>
                    <td><?= htmlspecialchars($client['clients_CNSS']) ?></td>
                    <td>
                        <a href="creer_entete.php?clients_id=<?= $client['clients_id'] ?>" class="btn-action">Créer en-tête</a>
                        <a href="importer_facture.php?clients_id=<?= $client['clients_id'] ?>" class="btn-action">Importer facture</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</body>
</html>