<?php
include 'includes/db.php';
require('fpdf.php'); // Utilisez la bibliothèque FPDF (https://github.com/memberstack/fpdf.php)

// Récupérer l'en-tête du client et la facture importée
$clients_id = $_GET['clients_id'];
$factures_id = $_GET['factures_id'];

// Récupérer les données du client
$stmt = $pdo->prepare("SELECT * FROM clients WHERE clients_id = ?");
$stmt->execute([$clients_id]);
$client = $stmt->fetch();

// Récupérer le fichier facture
$stmt = $pdo->prepare("SELECT factures_fichier FROM factures WHERE factures_id = ?");
$stmt->execute([$factures_id]);
$facture = $stmt->fetch();

// Créer un PDF avec FPDF
$pdf = new FPDF();
$pdf->AddPage();

// Ajouter l'en-tête (logo et informations)
$pdf->SetFont('Arial', 'B', 16);
$pdf->Cell(0, 10, $client['clients_nom_entreprise'], 0, 1);
$pdf->Image($client['clients_logo'], 10, 20, 50); // Ajustez les coordonnées

// Ajouter la facture importée (PDF/image)
if (pathinfo($facture['factures_fichier'], PATHINFO_EXTENSION) === 'pdf') {
    // Pour les PDF : utilisez une bibliothèque comme FPDI pour fusionner les pages
    // Exemple simplifié ici (à adapter)
    $pdf->AddPage();
    $pdf->SetFont('Arial', '', 12);
    $pdf->MultiCell(0, 10, "Facture importée : {$facture['factures_fichier']}");
} else {
    // Pour les images : ajoutez l'image au PDF
    $pdf->AddPage();
    $pdf->Image($facture['factures_fichier'], 10, 50, 180); // Ajustez la taille
}

// Générer le PDF en sortie (pas de stockage en base de données)
$pdf->Output('D', 'facture_finale.pdf'); // 'D' pour téléchargement direct
exit;
?>